<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTerminationTable extends Migration {

	public function up()
	{
		Schema::create('employee_termination', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('reason_id')->nullable();
			$table->datetime('date')->nullable();
			$table->double('bonus')->nullable();
			$table->text('notes_en')->nullable();
			$table->text('notes_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('employee_termination');
	}
}