<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceVenueInformationsTable extends Migration {

	public function up()
	{
		Schema::create('service_venue_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_information_id')->unsigned();
			$table->string('service_offered');
			$table->string('ceremony_reception_type');
			$table->string('service_location');
			$table->string('indoor_capacity');
			$table->string('outdoor_capacity');
			$table->string('adult_guest_minimum');
			$table->string('min_event_durations_hours');
			$table->boolean('coordinator_required');
			$table->boolean('can_host_more_event_at_a_time');
			$table->boolean('approved_outside_vendors_only');
			$table->boolean('require_outside_vendors_to_have_insurance');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_venue_informations');
	}
}