<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->boolean('opted_in')->default(0);
			$table->datetime('accepted_at');
			$table->string('email');
			$table->datetime('email_verified_at');
			$table->string('password');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}