<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceInformationsTable extends Migration {

	public function up()
	{
		Schema::create('service_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('states_served')->nullable();
			$table->boolean('lgbt_friendly')->nullable();
			$table->boolean('pet_friendly');
			$table->boolean('handicap_accessible')->nullable();
			$table->string('peak_season_month')->nullable();
			$table->double('peak_season_booking_minimum')->nullable();
			$table->boolean('peak_budget_below_minimum')->nullable();
			$table->double('off_season_booking_minimum')->nullable();
			$table->boolean('off_peak_budget_below_minimum')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_informations');
	}
}