<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceFacilityRestrictionsTable extends Migration {

	public function up()
	{
		Schema::create('service_facility_restrictions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_information_id')->unsigned();
			$table->string('catering');
			$table->string('alcohol');
			$table->string('smoking');
			$table->string('special_decorations');
			$table->string('parking');
			$table->string('music');
			$table->time('indoor_music_end_by')->nullable();
			$table->time('outdoor_music_end_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_facility_restrictions');
	}
}