<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceVenueMenuChoicesTable extends Migration {

	public function up()
	{
		Schema::create('service_venue_menu_choices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_information_id')->unsigned();
			$table->string('menu_type_choices');
			$table->string('special_dietary_preferences');
			$table->string('soft_drinks_juices_offered');
			$table->string('online_menu_link')->nullable();
			$table->string('cocktail_hour_service_choices')->nullable();
			$table->string('cocktail_hour_alcohol_offered');
			$table->string('alcohol_type');
			$table->string('menu_pricing_packages')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_venue_menu_choices');
	}
}