<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

	public function messageable()
	{
		return $this->morphTo();
	}

	public function logs()
	{
		return $this->morphMany('App\Models\Log');
	}

	public function events()
	{
		return $this->morphMany('App\Models\Event');
	}

}