<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Endpoint extends Eloquent {

	protected $table = 'endpoints';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function credential()
	{
		return $this->belongsTo('App\Models\Credential');
	}

	public function logs()
	{
		return $this->morphMany('App\Models\Log');
	}

}