<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Credential extends Eloquent {

	protected $table = 'credentials';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function webhooks()
	{
		return $this->hasMany('App\Models\Endpoint');
	}

}