<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('manufacturer_id')->references('id')->on('manufacturers')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('transmission_id')->references('id')->on('transmissions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('usage_id')->references('id')->on('usages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_owner_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_manufacturer_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_transmission_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_usage_id_foreign');
		});
	}
}