<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('owner_id')->unsigned();
			$table->integer('manufacturer_id')->unsigned();
			$table->integer('transmission_id')->unsigned();
			$table->integer('usage_id')->unsigned();
			$table->string('model');
			$table->string('license_plate');
			$table->string('colour');
			$table->integer('weight_category');
			$table->integer('no_seats');
			$table->boolean('has_boot');
			$table->boolean('has_trailer');
			$table->boolean('is_hgv');
			$table->integer('no_doors');
			$table->boolean('sunroof');
			$table->boolean('has_gps');
			$table->integer('no_wheels');
			$table->integer('engine_cc');
			$table->string('fuel_type');
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}