<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanTable extends Migration {

	public function up()
	{
		Schema::create('plan', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('product_id');
			$table->integer('plan_category_id');
			$table->string('name', 255);
			$table->integer('amount');
			$table->longText('description');
			$table->integer('deposit');
			$table->integer('tax');
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plan');
	}
}