<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTable extends Migration {

	public function up()
	{
		Schema::create('admin', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->timestamp('email_verified_at');
			$table->string('password', 255);
			$table->string('remember_token', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin');
	}
}