<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('service_amount_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->string('status');
			$table->string('batch_id', 255);
			$table->integer('event_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}