<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('service_custom_input', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_amount', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_amount', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('service_amount_id')->references('id')->on('service_custom_input')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('service_amount_id')->references('id')->on('service_amount')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('cast_id')->references('id')->on('caste')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_subscription', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('user_subscription', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_custom_input', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('service_custom_input', function(Blueprint $table) {
			$table->dropForeign('service_custom_input_service_id_foreign');
		});
		Schema::table('service_amount', function(Blueprint $table) {
			$table->dropForeign('service_amount_service_id_foreign');
		});
		Schema::table('service_amount', function(Blueprint $table) {
			$table->dropForeign('service_amount_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_user_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_service_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_service_amount_id_foreign');
		});
		Schema::table('cart', function(Blueprint $table) {
			$table->dropForeign('cart_event_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_service_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_service_amount_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_event_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_cast_id_foreign');
		});
		Schema::table('user_subscription', function(Blueprint $table) {
			$table->dropForeign('user_subscription_user_id_foreign');
		});
		Schema::table('user_subscription', function(Blueprint $table) {
			$table->dropForeign('user_subscription_subscription_id_foreign');
		});
		Schema::table('event_custom_input', function(Blueprint $table) {
			$table->dropForeign('event_custom_input_event_id_foreign');
		});
	}
}