<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('title')->nullable();
			$table->string('image')->nullable();
			$table->enum('type', array('country', 'city', 'area'))->nullable();
			$table->string('country_code')->nullable();
			$table->integer('parent_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}