<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('trip_id')->unsigned();
			$table->integer('guide_id')->unsigned();
			$table->string('price')->nullable();
			$table->enum('status', array('waiting', 'accepted', 'refused'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}