<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('route', 'activity'))->nullable();
			$table->string('title')->nullable();
			$table->integer('service_category_id')->unsigned()->nullable();
			$table->string('duration')->nullable();
			$table->integer('guide_id')->unsigned()->nullable();
			$table->string('price')->nullable();
			$table->string('persons')->nullable();
			$table->text('description')->nullable();
			$table->string('address')->nullable();
			$table->enum('target_group', array('all', 'partners', 'families', 'singles'))->nullable();
			$table->string('main_image')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('area_id')->unsigned()->nullable();
			$table->enum('children', array('free', 'paid'))->nullable();
			$table->string('children_age')->nullable();
			$table->text('feature')->nullable();
			$table->time('start_time')->nullable();
			$table->enum('has_offer', array('true', 'false'))->nullable();
			$table->enum('admin_approve', array('waiting', 'accept', 'refuse'))->nullable();
			$table->string('lat')->nullable();
			$table->string('lng')->nullable();
			$table->string('currency')->nullable();
			$table->date('date_start')->nullable();
			$table->time('time_start')->nullable();
			$table->date('date_end')->nullable();
			$table->time('time_end')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}