<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUpdatesRequestsTable extends Migration {

	public function up()
	{
		Schema::create('updates_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('image')->nullable();
			$table->string('name')->nullable();
			$table->string('mobile')->nullable();
			$table->integer('country_code_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('email')->nullable();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->string('bank_name')->nullable();
			$table->string('bank_image')->nullable();
			$table->string('account_number')->nullable();
			$table->enum('account_type', array('captain', 'provider'))->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('certification_image')->nullable();
			$table->string('id_number')->nullable();
			$table->string('experience')->nullable();
			$table->enum('approve_status', array('waiting', 'accepted', 'refused'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('updates_requests');
	}
}