<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->text('body')->nullable();
			$table->enum('type', array('admin', 'trip'))->nullable();
			$table->enum('seen', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}