<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_code_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_images', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_attachments', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_attachments', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('regiments', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_offers', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('service_favourites', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('distinations', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('service_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('customized_trips')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->foreign('guide_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('event_images', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('discover_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('discover_images', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('discover_items')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->foreign('country_code_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_code_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_currency_id_foreign');
		});
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->dropForeign('device_tokens_user_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_category_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_guide_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_country_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_city_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_area_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_parent_id_foreign');
		});
		Schema::table('service_images', function(Blueprint $table) {
			$table->dropForeign('service_images_service_id_foreign');
		});
		Schema::table('service_attachments', function(Blueprint $table) {
			$table->dropForeign('service_attachments_service_id_foreign');
		});
		Schema::table('service_attachments', function(Blueprint $table) {
			$table->dropForeign('service_attachments_attachment_id_foreign');
		});
		Schema::table('regiments', function(Blueprint $table) {
			$table->dropForeign('regiments_service_id_foreign');
		});
		Schema::table('service_offers', function(Blueprint $table) {
			$table->dropForeign('service_offers_service_id_foreign');
		});
		Schema::table('service_favourites', function(Blueprint $table) {
			$table->dropForeign('service_favourites_user_id_foreign');
		});
		Schema::table('service_favourites', function(Blueprint $table) {
			$table->dropForeign('service_favourites_service_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_guide_id_foreign');
		});
		Schema::table('distinations', function(Blueprint $table) {
			$table->dropForeign('distinations_city_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_client_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_category_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_country_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_city_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_offer_id_foreign');
		});
		Schema::table('customized_trips', function(Blueprint $table) {
			$table->dropForeign('customized_trips_guide_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_trip_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_guide_id_foreign');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->dropForeign('suggested_services_guide_id_foreign');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->dropForeign('suggested_services_country_id_foreign');
		});
		Schema::table('suggested_services', function(Blueprint $table) {
			$table->dropForeign('suggested_services_city_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_country_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_city_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_type_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('event_images', function(Blueprint $table) {
			$table->dropForeign('event_images_event_id_foreign');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->dropForeign('wallet_charges_user_id_foreign');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->dropForeign('discover_items_category_id_foreign');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->dropForeign('discover_items_country_id_foreign');
		});
		Schema::table('discover_items', function(Blueprint $table) {
			$table->dropForeign('discover_items_city_id_foreign');
		});
		Schema::table('discover_images', function(Blueprint $table) {
			$table->dropForeign('discover_images_item_id_foreign');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->dropForeign('updates_requests_user_id_foreign');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->dropForeign('updates_requests_country_code_id_foreign');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->dropForeign('updates_requests_city_id_foreign');
		});
		Schema::table('updates_requests', function(Blueprint $table) {
			$table->dropForeign('updates_requests_currency_id_foreign');
		});
	}
}