<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email')->unique()->nullable();
			$table->string('mobile')->unique()->nullable();
			$table->integer('country_code_id')->unsigned()->nullable();
			$table->string('password')->nullable();
			$table->enum('type', array('client', 'guide'))->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->enum('admin_approve', array('true', 'false'))->nullable();
			$table->string('confirm_code')->nullable();
			$table->enum('confirmation_status', array('true', 'false'))->nullable();
			$table->string('image')->nullable();
			$table->string('wallet')->nullable();
			$table->string('id_number')->nullable();
			$table->string('age')->nullable();
			$table->enum('verified', array('true', 'false'))->nullable();
			$table->string('rank')->nullable();
			$table->enum('account_type', array('captain', 'provider'))->nullable();
			$table->string('certification_image')->nullable();
			$table->string('bank_name')->nullable();
			$table->string('bank_image')->nullable();
			$table->string('account_number')->nullable();
			$table->string('experience')->nullable();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->enum('completed_register', array('true', 'false'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}