<?php

namespace Jiri;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Implementation extends Model 
{

    protected $table = 'implementations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'student_id', 'jiri_id', 'weight', 'mean_score');

    public function project()
    {
        return $this->belongsTo('Project');
    }

    public function student()
    {
        return $this->belongsTo('Student');
    }

    public function scores()
    {
        return $this->hasMany('Score');
    }

    public function event()
    {
        return $this->belongsTo('Jiri');
    }

}