<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScoresTable extends Migration {

	public function up()
	{
		Schema::create('scores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('implementation_id')->unsigned();
			$table->decimal('score')->nullable();
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('scores');
	}
}