<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->rememberToken();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('company')->nullable();
			$table->boolean('is_admin')->default(false);
			$table->string('token')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}