<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Impression extends Eloquent {

	protected $table = 'impressions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'student_id', 'jiri_id', 'general_evaluation');

	public function student()
	{
		return $this->belongsTo('Student');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function scores()
	{
		return $this->hasMany('Score');
	}

	public function event()
	{
		return $this->belongsTo('Jiri');
	}

}