<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Jiri extends Eloquent {

	protected $table = 'jiries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'scheduled_on', 'is_active');

	public function implementations()
	{
		return $this->hasMany('Implementation', 'event_id');
	}

	public function performances()
	{
		return $this->hasMany('Performance');
	}

	public function projects()
	{
		return $this->belongsToMany('Project')->withPivot('weights');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function Students()
	{
		return $this->morphedByMany('Jiri\Student');
	}

}