<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email');

	public function meetings()
	{
		return $this->hasMany('Impression');
	}

	public function implementations()
	{
		return $this->hasMany('Implementation');
	}

	public function projects()
	{
		return $this->belongsToMany('Project');
	}

}