<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'company', 'is_admin', 'token');

	public function meetings()
	{
		return $this->hasMany('Impression');
	}

	public function events()
	{
		return $this->hasMany('Jiri');
	}

}