<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->string('name', 100);
			$table->integer('brand_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->text('description')->default('No Description Available');
			$table->text('primary_image');
			$table->json('360_view')->nullable();
			$table->date('release_date');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}