<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('enroll_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('status', array('paid', 'partial', 'due'))->nullable();
			$table->bigInteger('parent_payment_id')->unsigned();
			$table->text('details')->nullable();
			$table->text('note')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}