<?php

namespace app/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rating', 'description', 'user_id', 'course_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function course()
	{
		return $this->belongsTo('Course');
	}

}