<?php

namespace app/Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('parent_id');

    public function parent_categories()
    {
        return $this->belongsToMany('app/Models\Category', 'parent_id');
    }

    public function courses()
    {
        return $this->hasMany('Course');
    }

}