<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTeamsTable extends Migration {

	public function up()
	{
		Schema::create('user_teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('team_id')->unsigned()->index();
			$table->tinyInteger('is_supervisor')->nullable()->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('user_teams');
	}
}