<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('deleted_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->foreign('skill_type_id')->references('skill_type_id')->on('lookup_skill_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('parent_team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_teams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_teams', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_created_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_updated_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_deleted_by_foreign');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->dropForeign('user_skills_user_id_foreign');
		});
		Schema::table('user_skills', function(Blueprint $table) {
			$table->dropForeign('user_skills_skill_id_foreign');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->dropForeign('skills_skill_type_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_parent_team_id_foreign');
		});
		Schema::table('user_teams', function(Blueprint $table) {
			$table->dropForeign('user_teams_user_id_foreign');
		});
		Schema::table('user_teams', function(Blueprint $table) {
			$table->dropForeign('user_teams_team_id_foreign');
		});
	}
}