<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Skill extends Eloquent {

	protected $table = 'skills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('skill_name', 'skill_slug', 'skill_type_id', 'capacity');
	protected $visible = array('skill_name', 'skill_type_id', 'capacity');

	public function skillType()
	{
		return $this->belongsTo('App\Models\LuSkillType', 'skill_type_id', 'skill_type_id');
	}

}