<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email', 'password', 'created_by', 'updated_by', 'deleted_by');
	protected $visible = array('email');

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill', 'user_skills', 'user_id', 'skill_id', 'id')->select('skills.*','user_skills.capacity as user_capacity');
	}

	public function teams()
	{
		return $this->belongsToMany('App\Models\Team', 'user_teams', 'user_id', 'team_id', 'id')->select('teams.*', 'user_teams.is_supervisor');
	}

}