<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('team_name');
			$table->integer('parent_team_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}