<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Batiment', function(Blueprint $table) {
			$table->foreign('Id_ecole')->references('id')->on('Ecole')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Connect', function(Blueprint $table) {
			$table->foreign('id_salle')->references('id')->on('Salle')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Connect', function(Blueprint $table) {
			$table->foreign('Id_Classe')->references('id')->on('Classe')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Salle', function(Blueprint $table) {
			$table->foreign('id_batiment')->references('id')->on('Batiment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Staff', function(Blueprint $table) {
			$table->foreign('StaffType')->references('id')->on('Role')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Schedule', function(Blueprint $table) {
			$table->foreign('Periode_ID')->references('id')->on('Periode')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Schedule', function(Blueprint $table) {
			$table->foreign('Planning_ID')->references('id')->on('Planning')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->foreign('Staff_Id')->references('id')->on('Staff')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->foreign('Matiere_ID')->references('id')->on('Matiere')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->foreign('Connect_ID')->references('id')->on('Connect')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->foreign('Days_ID')->references('id')->on('Days')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Presence', function(Blueprint $table) {
			$table->foreign('Planning_ID')->references('id')->on('Planning')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Presence', function(Blueprint $table) {
			$table->foreign('Student_ID')->references('id')->on('Student')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Batiment', function(Blueprint $table) {
			$table->dropForeign('Batiment_Id_ecole_foreign');
		});
		Schema::table('Connect', function(Blueprint $table) {
			$table->dropForeign('Connect_id_salle_foreign');
		});
		Schema::table('Connect', function(Blueprint $table) {
			$table->dropForeign('Connect_Id_Classe_foreign');
		});
		Schema::table('Salle', function(Blueprint $table) {
			$table->dropForeign('Salle_id_batiment_foreign');
		});
		Schema::table('Staff', function(Blueprint $table) {
			$table->dropForeign('Staff_StaffType_foreign');
		});
		Schema::table('Schedule', function(Blueprint $table) {
			$table->dropForeign('Schedule_Periode_ID_foreign');
		});
		Schema::table('Schedule', function(Blueprint $table) {
			$table->dropForeign('Schedule_Planning_ID_foreign');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->dropForeign('Planning_Staff_Id_foreign');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->dropForeign('Planning_Matiere_ID_foreign');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->dropForeign('Planning_Connect_ID_foreign');
		});
		Schema::table('Planning', function(Blueprint $table) {
			$table->dropForeign('Planning_Days_ID_foreign');
		});
		Schema::table('Presence', function(Blueprint $table) {
			$table->dropForeign('Presence_Planning_ID_foreign');
		});
		Schema::table('Presence', function(Blueprint $table) {
			$table->dropForeign('Presence_Student_ID_foreign');
		});
	}
}