<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStaffTable extends Migration {

	public function up()
	{
		Schema::create('Staff', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('StaffType')->unique()->unsigned();
			$table->string('FirstName', 100)->default('FirstName');
			$table->string('LastName');
			$table->datetime('DateOfBirth');
			$table->string('Sex', 10);
			$table->string('MobilePhone', 50);
			$table->datetime('HireDate');
			$table->string('YearOfService');
			$table->string('Picture');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Staff');
	}
}