<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('buyer_id');
			$table->bigIncrements('seller_id');
			$table->string('deal');
			$table->bigInteger('price');
			$table->enum('paid', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}