<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('patient_name');
			$table->string('patient_age');
			$table->integer('blood_type_id')->unsigned();
			$table->string('hospital_name');
			$table->string('hospital_address');
			$table->string('phone');
			$table->integer('city_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->text('notes');
			$table->string('latitude');
			$table->string('longitude');
			$table->string('bags_num');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}