<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderAgentTable extends Migration {

	public function up()
	{
		Schema::create('order_agent', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('agent_id')->unsigned();
			$table->text('note')->nullable();
			$table->enum('status', array('pending', 'accept', 'success', 'reject', ''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_agent');
	}
}