<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResponsiblesTable extends Migration {

	public function up()
	{
		Schema::create('responsibles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->integer('level');
			$table->integer('number');
			$table->integer('time');
			$table->double('price');
			$table->double('discount_manager_percent')->nullable();
			$table->double('discount_manager_amount')->nullable();
			$table->double('short_term')->nullable();
			$table->double('shortterm_before')->nullable();
			$table->double('installment')->nullable();
			$table->double('installment_percent')->nullable();
			$table->double('tax')->default('9');
			$table->boolean('round_it')->default(1);
			$table->string('position')->default('1000');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('responsibles');
	}
}