<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCarsTable extends Migration {

	public function up()
	{
		Schema::create('user_cars', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('car_usages')->unsigned();
			$table->integer('car_id')->unsigned();
			$table->integer('model_id')->unsigned();
			$table->string('production_year')->nullable();
			$table->string('day_duration')->nullable();
			$table->string('life_loss_count')->nullable();
			$table->string('financial_loss_count')->nullable();
			$table->string('person_loss_count')->nullable();
			$table->string('last_day_duration')->nullable();
			$table->string('last_unique_code')->nullable();
			$table->string('last_insurance_no')->nullable();
			$table->integer('last_brand_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_cars');
	}
}