<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function profile()
	{
		return $this->hasOne('\Profile');
	}

	public function addresses()
	{
		return $this->hasMany('UserAddress');
	}

}