<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBodiesTable extends Migration {

	public function up()
	{
		Schema::create('bodies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unique()->unsigned();
			$table->longText('description')->nullable();
			$table->double('no_discount')->nullable();
			$table->string('shortterm');
			$table->double('shortterm_before')->default('0');
			$table->string('installment')->default('0');
			$table->double('installment_percent')->default('0');
			$table->boolean('round_it')->nullable()->default(1);
			$table->double('is_danger')->nullable();
			$table->double('penalti_delay')->nullable();
			$table->double('penalti_older')->nullable();
			$table->double('sum_transfer_price')->nullable();
			$table->double('sum_discount')->nullable()->default('80');
			$table->integer('position')->default('1000');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bodies');
	}
}