<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBodyDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('body_discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('body_id')->unsigned();
			$table->double('zero')->nullable()->index();
			$table->double('cash')->nullable()->index();
			$table->double('occasion')->nullable()->index();
			$table->double('CarQuality')->nullable();
			$table->double('manager')->nullable()->index();
			$table->boolean('is_active')->default(1);
			$table->double('is_danger_main')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('body_discounts');
	}
}