<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('fullname')->nullable();
			$table->string('slug')->nullable();
			$table->text('description')->nullable();
			$table->text('content')->nullable();
			$table->string('year_creator')->nullable();
			$table->integer('agent_count')->nullable();
			$table->integer('branches');
			$table->integer('power');
			$table->integer('customer_rate');
			$table->integer('delay');
			$table->integer('complain_rank');
			$table->integer('shop_share');
			$table->integer('summary_rank');
			$table->integer('center_rank');
			$table->enum('round_it', array('false', 'top', 'down'));
			$table->tinyInteger('is_active')->default('1');
			$table->integer('position')->default('100');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}