<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHealthsTable extends Migration {

	public function up()
	{
		Schema::create('healths', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->string('name')->nullable();
			$table->double('0-15')->default('0');
			$table->double('16-50')->default('0');
			$table->double('51-60')->default('0');
			$table->double('61-70')->default('0');
			$table->string('type')->nullable();
			$table->string('form_complete')->nullable();
			$table->string('Franchise')->nullable();
			$table->string('period_other')->nullable();
			$table->string('period_childbirth')->nullable();
			$table->string('period_chronic')->nullable();
			$table->double('cover_hospitalization')->nullable();
			$table->double('cover_surgery')->nullable();
			$table->double('cover_sonography')->nullable();
			$table->double('cover_brain_bar')->nullable();
			$table->double('cover_laboratory')->nullable();
			$table->double('cover_ambulance')->nullable();
			$table->double('cover_childbirth')->nullable();
			$table->double('cover_visit')->nullable();
			$table->double('cover_dentistry')->nullable();
			$table->double('cover_sterile')->nullable();
			$table->double('cover_eyes')->nullable();
			$table->double('cover_earphone')->nullable();
			$table->double('discount_manager_percent')->nullable();
			$table->double('discount_manager_amount')->nullable();
			$table->integer('short_term')->nullable();
			$table->double('shortterm_before')->nullable();
			$table->integer('installment')->nullable();
			$table->double('installment_percent')->nullable();
			$table->boolean('round_it')->default(1);
			$table->double('tax')->default('9');
			$table->string('position')->default('1000');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->double('cover_decrepitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('healths');
	}
}